#version 330
#extension GL_EXT_gpu_shader4 : enable
//Black and WhiteMod01.fsh  by  Logos 
//https://www.shadertoy.com/view/3dSXzt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Robert Śmietana (Logos) - 30.12.2019
// Bielsko-Biała, Poland, UE, Earth, Sol, Milky Way, Local Group, Laniakea :)


//--- auxiliary functions ---//

vec2 cmul(vec2 z1, vec2 z2) { return vec2(z1.x * z2.x - z1.y * z2.y, z1.x * z2.y + z1.y * z2.x ); }
vec2 cdiv(vec2 z1, vec2 z2) { vec2 conj = vec2(z2.x, -z2.y); return cmul(z1, conj) / (length(z2) * length(z2)); }

vec2 ccos(vec2 z)			{ return vec2(cos(z.x) * cosh(z.y), -sin(z.x) * sinh(z.y)); }
vec2 csin(vec2 z)			{ return vec2(sin(z.x) * cosh(z.y),  cos(z.x) * sinh(z.y)); }

vec2 newton(vec2 z)			{ return z - (1.35 - 0.35 * sin(0.3*iTime))*cdiv(csin(z), ccos(z)); }
vec2 rot(vec2 z, float a)	{ return vec2(z.x*cos(a) - z.y*sin(a), z.y*cos(a) + z.x*sin(a)); }


//--- calculate pixel color ---//

vec3 calculateColor(vec2 z)
{
    
    //--- invert complex plane ---//
    
    z = vec2(z.x, z.y) / dot(z, z);

    
    //--- iterate newton formula until small const (0.14) ---//
    
    int i = 0;
    for (i = 0; i < 80; i++)
    {
        vec2 n = newton(z);
        if (length(z - n) < 0.14) break;
        
        z = rot(n, 0.401*sin(0.512*iTime));
    }
    
    
    //--- return color by binary decomposition ---//
    
    return	z.x < 0.0? vec3(0.0) :
	    	z.y < 0.0? vec3(1.0 - 0.5*log(float(i)/80.0), 0.95, 0.9 - 0.39*float(i)/80.0) : vec3(1.0);
}

void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    
    //--- calculate point coordinates ---//
    
	float ZOOM = 1.8;
    vec2 z = ZOOM * (gl_FragCoord.xy - 0.5*iResolution.xy) / iResolution.y;
    
    
    //--- calculate final pixel color ---//
    
    float a = 2.0;
    float e = 0.5/min(iResolution.x, iResolution.y);    
    vec3 col = vec3(0.0);
    
    for (float j = -a; j < a; j++)
        for (float i = -a; i < a; i++)
            col += calculateColor(z + ZOOM*vec2(i, j) * (e/a)) / (4.0*a*a);
        
	gl_FragColor = vec4(col, 1.0);  
    
}
